using System; 
using Server.Items; 

namespace Server.Mobiles 
{ 
    
	public class SpectralScimitar : BaseSummoned 
	{ 
		public override WeaponAbility GetWeaponAbility()
		{
			switch ( Utility.Random( 3 ) )
			{
				default:
					case 0: return WeaponAbility.DoubleStrike;
					case 1: return WeaponAbility.WhirlwindAttack;
					case 2: return WeaponAbility.BleedAttack;
			}
		}

		[Constructable] 
		public SpectralScimitar() : base( AIType.AI_Melee, FightMode.Closest, 10, 1, 0.2, 0.4 ) 
		{ 
			Body = 637; 
			Hue = 2633;//0x8026; 
			Name = "spectral scimitar";
         BaseSoundID = 466;
			
			ControlSlots = 1;

			Buckler buckler = new Buckler();
			ChainCoif coif = new ChainCoif();
			PlateGloves gloves = new PlateGloves();

			buckler.Hue = 0x835; buckler.Movable = false;
			coif.Hue = 0x835;
			gloves.Hue = 0x835;

			AddItem( buckler );
			AddItem( coif );
			AddItem( gloves );

			SetStr( 741, 750 ); 
			SetDex( 401, 410 ); 
			SetInt( 101, 110 );

			SetHits( 578, 601 );
			SetStam( 191, 200 );

			SetDamage( 30, 40 );

			SetDamageType( ResistanceType.Physical, 75 );
			SetDamageType( ResistanceType.Cold, 25 );

			SetResistance( ResistanceType.Physical, 35, 45 );
			SetResistance( ResistanceType.Fire, 20, 30 );
			SetResistance( ResistanceType.Cold, 30, 40 );
			SetResistance( ResistanceType.Poison, 20, 30 );
			SetResistance( ResistanceType.Energy, 20, 30 );

			SetSkill( SkillName.Wrestling, 120.1, 150.0 ); 
			SetSkill( SkillName.Tactics, 120.1, 150.0 ); 
			SetSkill( SkillName.MagicResist, 120.1, 150 ); 

			VirtualArmor = 40; 
		}

		public override int GetIdleSound()
		{
			return 0x200;
		}

		public override int GetAngerSound()
		{
			return 0x56;
		}

		public override bool OnBeforeDeath()
		{
			Effects.SendLocationEffect( Location, Map, 0x376A, 10, 1 );
			Hits = HitsMax;
         return false;
		}
		
		public override Poison PoisonImmune{ get{ return Poison.Lethal; } }

		public SpectralScimitar( Serial serial ) : base( serial ) 
		{ 
		} 

		public override void Serialize( GenericWriter writer ) 
		{ 
			base.Serialize( writer ); 
			writer.Write( (int) 0 ); 
		} 

		public override void Deserialize( GenericReader reader ) 
		{ 
			base.Deserialize( reader ); 
			int version = reader.ReadInt(); 
		} 
	} 
}